// priority : 100
// Beacon advancements!
// by Feed the Beast and R3GEN on 2022-03-04
// Not sure if you can reuse this as is in other modpacks, ask us in the FTB Discord.

// Possible beacon configurations and sizes, and which advancement they will trigger on completion
let configurations = [
    netherite_block = {
        block_id: "minecraft:netherite_block",
        beacon_size_required: 4,
        advancement: "plexiglassmountain:story/netherite_beacon"
    },
    creativerite_block = {
        block_id: "kubejsadditions:tesseracted_plexiglass",
        beacon_size_required: 4,
        advancement: "plexiglassmountain:story/tesseracted_plexiglass_beacon"
    }
];

// isUniformBlockRange: For every block within the prism generated by two coordinates, check if the block correspond to
// a specific block. If all blocks match with the target, returns true, else false.
// "coordsOne" needs to be the smaller coordinate both in X and Z compared to "coordsTwo".
var isUniformBlockRange = (coordsOne, coordsTwo, targetId, level) => {

    // How much blocks do we need to check in total?
    // If the coordinates are on the same Y level, say 70, then we still need to check at least 1 layer of Y.
    // Since 70 - 70 = 0, we then need to add 1 for our counter!
    let travelsX = coordsTwo.x - coordsOne.x + 1;
    let travelsY = coordsTwo.y - coordsOne.y + 1;
    let travelsZ = coordsTwo.z - coordsOne.z + 1;

    // Travel each block in the prism defined by the two coordinates
    for (let x = 0; x < travelsX; x++) {
        for (let y = 0; y < travelsY; y++) {
            for (let z = 0; z < travelsZ; z++) {

                // Get the block that we need to check at a specific position
                var blockIdToCheck = level.getBlock(coordsOne.x + x, coordsOne.y + y, coordsOne.z + z).id

                // If the block we are currently checking does not match what we wanted to see there (e.g. Netherite block)
                // then don't continue checking other blocks, immediately return false.
                if (blockIdToCheck != targetId) {
                    return false;
                }
            }
        }
    }

    // Else all checks suceeded for that block range, return true!
    return true;
}

onEvent("player.advancement", (event) => {

    // Get the advancement
    ad = event.getAdvancement();

    // Check if it's the watcher advancement granted to player placing a beacon
    if (ad.toString() == "plexiglassmountain:story/place_beacon") {

        // Then reset the advancement in any case straight away, we don't want to mess with external storage to hold data for
        // players completing the advancements, Minecraft does that already
        pname = event.player.getName().getString();
        event.getEntity().getServer().runCommandSilent("/advancement revoke " + pname + " only plexiglassmountain:story/place_beacon")

        // Get the block the player is looking at, which should be a beacon
        var beacon = event.player.rayTrace().block

        // Doublecheck that it is a beacon (could be overkill to do so but oh well)
        if (beacon.id == "minecraft:beacon") {

            // Check that the block right under the beacon is in the permitted configurations
            let validConfiguration = false;
            let configIterator = 0;
            while (configIterator < configurations.length && !validConfiguration) {

                // Get block under beacon
                let blockUnderBeacon = event.player.level.getBlock(beacon.x, beacon.y - 1, beacon.z).id

                // Is that block part of the current iteration in configurations?
                if (blockUnderBeacon != configurations[configIterator].block_id) {

                    // No, then continue and check the next configuration.
                    configIterator++;
                    continue;
                } else {
                    
                    // Yes, then set the flag, this will break the loop.
                    validConfiguration = true;
                }
            }

            // If the block under the beacon matches one of the configurations
            if (validConfiguration) {

                // Set another flag which will check if the beacon is filled with the correct blocks on each layer
                var isFilledWithTheRightBlock = true;

                // Loop for the beacon size in the configuration. Shift it by one so i = 1, start at one block under the beacon.
                // Add one to beacon size just so it matches that shift to i.
                // Example: beacon size = 4 will loop from [1,5[
                // Checks one layer at a time
                for (var i = 1; i < configurations[configIterator].beacon_size_required + 1 && isFilledWithTheRightBlock; i++) {

                    // Set what the prism coordinates will be. coordsOne < coordsTwo
                    coordsOne = { x: beacon.pos.x - i, y: beacon.pos.y - i, z: beacon.pos.z - i, }
                    coordsTwo = { x: beacon.pos.x + i, y: beacon.pos.y - i, z: beacon.pos.z + i, }

                    // Check if the layer is uniform to the target block in the configurations
                    isFilledWithTheRightBlock = isUniformBlockRange(coordsOne, coordsTwo, configurations[configIterator].block_id, event.player.level)
                }

                // Is the beacon filled with the right block all the way?
                if (isFilledWithTheRightBlock) {

                    // Congratz to the player and grant them the achievement
                    // Doesn't matter if it gets called over and over, Minecraft won't show it popping twice in game, only the first time
                    // Hence we don't save anything related to players, keeping this simpler
                    event.getEntity().getServer().runCommandSilent("/advancement grant " + pname + " only " + configurations[configIterator].advancement)
                }
                else {
                    // The completed beacon has an incorrect block, we do nothing
                }
            } else {
                // The block under the beacon is not contained in the configurations, we do nothing
            }
        } else {
            // Somehow the block the player is looking at is no longer a beacon, we do nothing
        }
    } else {
        // If you have other watcher advancements or want to do special stuff when a player gets a special advancement...
        // For example, when player beats the dragon, shoot fireworks
        // Then it goes here and this current selector becomes a "else if" instead of just "else".
        // else if (ad.toString() == "minecraft:end/kill_dragon"){ }
    }
})